//=============================================================================
//  MuseScore
//  Linux Music Score Editor
//  $Id:$
//
//  Shakuhachi Notation plugin
//
//  Copyright (C)2010-2014 Hiroshi Tachibana
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License version 2.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//=============================================================================
//
// This is ECMAScript code (ECMA-262 aka "Java Script")
//
//---------------------------------------------------------
//    init
//    this function will be called on startup of mscore
//---------------------------------------------------------
var fingerings = [ "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", 
"M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X",
 "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", 
"m", "n", "o", "p", "q", "r"] 

function init(){}
//-------------------------------------------------------------------
//    run
//    this function will be called when activating the
//    plugin menu entry
//
//    global Variables:
//    pluginPath - contains the plugin path; file separator is "/"
//-------------------------------------------------------------------
function run(){
	if (typeof curScore === 'undefined') return;
	var loader = new QUiLoader(null);
	var file   = new QFile(pluginPath + "/Shakuhachi.ui"); // 外部Qtファイルの指定
	file.open(QIODevice.OpenMode(QIODevice.ReadOnly, QIODevice.Text));
	form = loader.load(file, null);
	form.buttonBox.accepted.connect(accept);
	form.exec();
}
//---------------------------------------------------------
//    accept
//    called when user presses "Accept" button
//---------------------------------------------------------
function accept(){
	var shakuhachiLength = form.mSpinBox.value; // 定義した変数に、外部Qtファイルからの値を設定する
	var fontType = form.mSpinBox2.value;
	var fontSize = form.mSpinBox3.value;
	var fontYOffset = form.mSpinBox4.value;
	
	if(fontType>=5) fontSize=fontSize*3; // 指使い表示の場合は、元が小さいので、フォントの大きさを３倍にする。

	if(fontType==1) var font = new QFont("Shakuhachi18", fontSize); // フォントの指定←
	else if(fontType==2) var font = new QFont("ShakuhachiO", fontSize);
	else if(fontType==3) var font = new QFont("ShakuhachiKinko", fontSize);
	else if(fontType==4) var font = new QFont("Arial", fontSize);
	else if(fontType==5) var font = new QFont("ShakuhachiFingeringTozan", fontSize);
	else if(fontType==6) var font = new QFont("ShakuhachiFingeringNotationTozan", fontSize);

	var CrLf = '\r\n'; // 和音を縦に表示するための改行用文字列
	var select=true; // 選択があるorないの判定用の論理型変数の定義
	var currentCursor = new Cursor(curScore);
	var selectionEnd = new Cursor(curScore);
	selectionEnd.goToSelectionEnd(); // 選択範囲の末端に移動
	var startStaff=currentCursor.staff; // 選択範囲の先頭小節
	var endStaff=selectionEnd.staff; // 選択範囲の末端小節

//	currentCursor.staff = 0; // 多段のスコアには自動的に対応せず（各段を選択することにより表示ができる）
//	currentCursor.voice = 0; // voice2〜4には対応せず
	currentCursor.rewind();  // 先頭に戻す

	currentCursor.goToSelectionStart(); // 選択範囲の先頭に移動
	if (currentCursor.eos()) { // 選択がない場合は、currentCursorは末端となる
		select=false;// 選択がない
		startStaff = 0; // 範囲の先頭は、最初の小節
		endStaff = curScore.staves; // 範囲の末尾は、最後の小節
	}
	currentCursor.goToSelectionStart(); // 先頭を現在位置にする
	if(!select)  currentCursor.rewind(); // 選択がないときは、先頭に戻して先頭から.
	while (currentCursor.tick() < selectionEnd.tick()) { // 現在位置が選択範囲内にいる場合
		if (currentCursor.isChord()) { // 現在位置が音符の場合
			var text  = new Text(curScore);
			var chordLength = currentCursor.chord().notes; // 和音の音数を取得

			if(fontType < 5){
				var len = chordLength-1; // 和音の音数を０から数えた場合
				while (len >= 0){ // 音符の読みを下から並べるための和音の音数のループ
					var pitch = currentCursor.chord().note(len).pitch; // 音符の音程の取得
					var index = pitch-78+shakuhachiLength; // 尺八の長さによって、指遣いを決める
					if(index >= 0 && index < fingerings.length-5){  // 音程が吹ける範囲内である場合
						if(fontType<=3) text.text += fingerings[index]+CrLf; // ロツレチ音名の文字設定
						else if(fontType==4) text.text += currentCursor.chord().note(len).name+CrLf; // 英語音名の文字設定
//						else text.text += fingerings[index]; // 指使い表示の場合は、縦に長いので改行しない
					}
					len = len-1; // 和音の音数のカウントを減らす
				}
			}else{
				var len = 0; // 和音のカウント
				while (len < chordLength){ // 音符の読みを上から並べるための和音の音数のループ
					var pitch = currentCursor.chord().note(len).pitch; // 音符の音程の取得
					var index = pitch-78+shakuhachiLength // 尺八の長さによって、指遣いを決める
					if(index >= 0 && index < fingerings.length-5){  // 音程が吹ける範囲内である場合
						text.text += fingerings[index]; // 指使い表示の場合は、縦に長いので改行しない
					}
					len = len+1; // 和音の音数のカウントを増やす
				}
			}
			text.defaultFont = font; // フォントの設定
			text.yOffset = fontYOffset; // 縦方向の位置設定
			currentCursor.putStaffText(text); // 画面に音符を表示
		}
		currentCursor.next(); // 次の音符に進める
	}
}

//---------------------------------------------------------
//    menu:  defines were the function will be placed
//           in the MuseScore menu structure
//---------------------------------------------------------

var mscorePlugin = {
      menu: 'Plugins.Shakuhachi Notation', // MuseScoreのプラグインメニューに表示されるタイトル
      init: init,
      run:  run
      };

mscorePlugin;
