/*
!!此程式碼中，若有任何編譯時錯誤，將不被顯示在plugin中(例如：在任一列中，僅輸入一個無意義的「*」字元)
*/
import QtQuick 2.2      //必要，此版本不低於程式碼所需之最低版本即可
import MuseScore 3.0    //必要

MuseScore {
	  
    title: "Simple Notation With xVacle"                             //在Musescore Plugin工具列中，所顯示的名稱                        //非必要(但建議有)
    thumbnailName: "coverOfSimpleNotationXVACLE.png"                        //在Musescore Plugin啟用選項中所顯示的icon                        //非必要
    description: qsTr("Simple Notation creator")                     //在Musescore Plugin啟用選項中所顯示的描述                        //非必要
    version: "1.0"                                                  //在Musescore Plugin啟用選項中所顯示的此Plugin版本號次			   //非必要(但建議有)
  
      
	onRun: {

		curScore.startCmd()							//接下來的所有動作，視為一個群組(用於復原時，僅屬於一個復原)

		applyToSelectionOrScore()

		curScore.endCmd()							//取消視為群組的指令(取消curScore.startCmd())

	}

	function applyToSelectionOrScore() {
		var args = Array.prototype.slice.call(arguments, 1)
		var staveBeg
		var staveEnd
		var tickEnd
		var rewindMode
		var toEOF

		var cursor = curScore.newCursor()
		cursor.rewind(Cursor.SELECTION_START)
		if (cursor.segment) {
			staveBeg = cursor.staffIdx
			cursor.rewind(Cursor.SELECTION_END)
			staveEnd = cursor.staffIdx
			if (!cursor.tick) {
				/*
				 * This happens when the selection goes to the
				 * end of the score — rewind() jumps behind the
				 * last segment, setting tick = 0.
				 */
				toEOF = true
			} else {
				toEOF = false
				tickEnd = cursor.tick
			}
			rewindMode = Cursor.SELECTION_START
		} else {
			/* no selection */
			staveBeg = 0
			staveEnd = curScore.nstaves - 1
			toEOF = true
			rewindMode = Cursor.SCORE_START
		}

		for (var stave = staveBeg; stave <= staveEnd; ++stave) {
			for (var voice = 0; voice < 4; ++voice) {
				cursor.staffIdx = stave
				cursor.voice = voice
				cursor.rewind(rewindMode)
				
				cursor.staffIdx = stave
				cursor.voice = voice

				while (cursor.segment && (toEOF || cursor.tick < tickEnd)) {
					if (cursor.element)
						putTextOn.apply(null, [cursor].concat(args))
					cursor.next()
				}
			}
		}

	}

	/*
	將countNoteSimple運算後的結果，用譜表文字(StaffText)顯示出來
	*/
	function putTextOn(myCursor) {

		if (myCursor.element.type !== Element.CHORD && myCursor.element.type !== Element.REST)								//Value: myCursor.element.type=108  ;  Element.CHORD=108
			return

		var myStaffText = newElement(Element.STAFF_TEXT)							//新增譜表文字(Staff Text)物件 (此時尚未add)
		myStaffText.text = ""														//(非必要)預設文字內容為空值

		if (myCursor.element.type == Element.CHORD) {
			var sep = ""																//(必要)文字內容設為空值
			for (var i = 0; i < myCursor.element.notes.length; ++i) {					//同時演奏1~(i+1)個音符
				myStaffText.text += sep + countNoteSimple(myCursor.element.notes[i])	//依序將音高，增列於譜表文字內容
				sep = "–"																//同時演奏多個音符時，用此符號區隔
			}
		} else if (myCursor.element.type == Element.REST) {							//設定休止符內容
			myStaffText.text += toAddRestDurationValue(myCursor.element)
		}

		if (myStaffText.text == "")
			return

		myStaffText.placement = Placement.BELOW										//設定譜表文字為：下方 (Above, Below二選一)
		myStaffText.autoplace = false												//關閉：自動設定譜表文字位置

		for (var verse = 0; verse < myCursor.voice; ++verse){
			myStaffText.text = '\n' + myStaffText.text
		}

		myCursor.add(myStaffText)													//將定義完成之譜表文字物件，新增至當前選取處

	}

	function countNoteSimple(note) {
		var name = ""

		name += toAddMainPitch(note)
		name += toAddAccidentalType(note)
		name += toAddOctaveAndDurationValue(note)

		return name

	}

	function toAddRestDurationValue(myRest){
		var tempName = "P"															//P:對照簡譜字型休止符，即0

		var tickMultiplier = 4														//根據Tick Length values進行乘數調整。https://musescore.github.io/MuseScore_PluginAPI_Docs/plugins/html/ticklength.html
		var durN = myRest.duration.numerator
		var durD = myRest.duration.denominator									//以durD分音符為一拍，有durN個此音符的長度。(不考量跨小節的情形)
		var noteDurationValue = tickMultiplier * division * (durN / durD)

		switch (noteDurationValue) {
			case 4 * division:						//whole note (semibreve)
				tempName += "ZZZ"
				break
			case 3.5 * division:					//double-dotted half note
				tempName += "vZZ"
				break
			case 3 * division:						//dotted half note
				tempName += "ZZ"
				break
			case 8 * division / 3:					//triplet whole note (1/3 of breve)					//三連音
				break
			case 2 * division:						//half note (minim)
				tempName += "Z"
				break
			case 1.75 * division:					//double-dotted crochet
				tempName += ".,"
				break
			case 1.5 * division:					//dotted crochet
				tempName += "."
				break
			case 4 * division / 3:					//triplet half note (1/3 of semibreve)				//三連音
				break
			case division:							//1/4 note (crochet)
				break
			case 0.875 * division:					//double-dotted quaver
				tempName += "v.,"
				break
			case 0.75 * division:					//dotted quaver
				tempName += "v."
				break
			case 2 * division / 3:					//triplet crochet (1/3 of minim)				//三連音
				break
			case division / 2:						//1/8 note (quaver)
				tempName += "v"
				break
			case 0.4375 * division:					//double-dotted semiquaver
				tempName += "f.,"
				break
			case 0.375 * division:					//dotted semiquaver
				tempName += "f."
				break
			case division / 3:						//triplet quaver (1/3 of crochet)				//三連音
				break
			case division / 4:						//1/16 note (semiquaver)
				tempName += "f"
				break
			case 0.21875 * division:				//double-dotted demi-semiquaver
				tempName += "r.,"
				break
			case 0.1875 * division:					//dotted demi-semiquaver
				tempName += "r."
				break
			case division / 6:						//triplet semiquaver (1/3 of quaver)			//三連音
				break
			case division / 8:						//1/32 note (demi-semiquaver)
				tempName += "r"
				break
			case 0.09375 * division:				//dotted hemi-demi-semiquaver
				break
			case division / 12:						//triplet demi-semiquaver (1/3 of semiquaver)	//三連音
				break
			case division / 16:						//1/64 note (hemi-demi-semiquaver)
				break
		}


		return tempName
	}


	//取得基準音高(尚未包含臨時記號)，依據tpc list。https://musescore.github.io/MuseScore_PluginAPI_Docs/plugins/html/tpc.html
	function toAddMainPitch(note) {
		switch (note.tpc1) {
			case -1:
			case 6:
			case 13:
			case 20:
			case 27:
				return "F"

			case 0:
			case 7:
			case 14:
			case 21:
			case 28:
				return "C"

			case 1:
			case 8:
			case 15:
			case 22:
			case 29:
				return "G"

			case 2:
			case 9:
			case 16:
			case 23:
			case 30:
				return "D"

			case 3:
			case 10:
			case 17:
			case 24:
			case 31:
				return "A"

			case 4:
			case 11:
			case 18:
			case 25:
			case 32:
				return "E"

			case 5:
			case 12:
			case 19:
			case 26:
			case 33:
				return "B"
		}
	}

	//增加臨時記號
	function toAddAccidentalType(note) {
		if (note.accidentalType == Accidental.FLAT2) {
			return "H"
		} else if (note.accidentalType == Accidental.FLAT) {
			return "J"
		} else if (note.accidentalType == Accidental.NATURAL) {
			return "K"
		} else if (note.accidentalType == Accidental.SHARP) {
			return "L"
		} else if (note.accidentalType == Accidental.SHARP2) {
			return ":"
		} else {
			return ""
		}
	}


	/*
	增加音符時值、音高。
	若音高低於C4，則時值橫線改用包含點的專屬橫線。
	*/
	function toAddOctaveAndDurationValue(note) {

		var tempName = ""

		var myOctave = Math.floor(note.pitch / 12) - 1								//取得絕對音高的8度部分。 例如：C4.pitch = 60  ->  60/12-1=5-1=4

		var tickMultiplier = 4														//根據Tick Length values進行乘數調整。https://musescore.github.io/MuseScore_PluginAPI_Docs/plugins/html/ticklength.html
		var durN = note.parent.duration.numerator
		var durD = note.parent.duration.denominator									//以durD分音符為一拍，有durN個此音符的長度。(不考量跨小節的情形)
		var noteDurationValue = tickMultiplier * division * (durN / durD)


		//增加上下8度、15度音高
		switch(myOctave) {
			case 2:
				if(noteDurationValue < division || noteDurationValue == 3.5 * division) break				//若時值：快於4分音符(音符有下加橫線)，或為雙附點2分音符。則暫不增加低音記號
				tempName += "s"											//15mb；下加2點
				break

			case 3:
				if(noteDurationValue < division || noteDurationValue == 3.5 * division) break				//若時值：快於4分音符(音符有下加橫線)，或為雙附點2分音符。則暫不增加低音記號
				tempName += "x"											//8mb；下加1點
				break
				
			case 5:
				tempName += "z"											//8va
				break

			case 6:
				tempName += "a"											//15ma
				break
		}

		//增加慢於4分音符(音符無下加橫線)的時值
		switch (noteDurationValue) {
			case 4 * division:						//whole note (semibreve)
				tempName += "ZZZ"
				break
			case 3.5 * division:					//double-dotted half note							//簡譜時，使用特殊記法
				if (myOctave == 2)	tempName += "nZZ"
				else if (myOctave == 3)	tempName += "bZZ"
				else tempName += "vZZ"
				break
			case 3 * division:						//dotted half note
				tempName += "ZZ"
				break
			case 8 * division / 3:					//triplet whole note (1/3 of breve)					//三連音
				break
			case 2 * division:						//half note (minim)
				tempName += "Z"
				break
			case 1.75 * division:					//double-dotted crochet
				tempName += ".,"
				break
			case 1.5 * division:					//dotted crochet
				tempName += "."
				break
			case 4 * division / 3:					//triplet half note (1/3 of semibreve)				//三連音
				break
			case division:							//1/4 note (crochet)
				break
		}

		//增加時值橫線
		//(若音高低於C4，則增加包含點的專屬橫線)
		if (myOctave == 2) {							//音高為C2~B2
			switch (noteDurationValue) {
				case 0.875 * division:					//double-dotted quaver
					tempName += "n.,"
					break
				case 0.75 * division:					//dotted quaver
					tempName += "n."
					break
				case 2 * division / 3:					//triplet crochet (1/3 of minim)				//三連音
					break
				case division / 2:						//1/8 note (quaver)
					tempName += "n"
					break
				case 0.4375 * division:					//double-dotted semiquaver
					tempName += "h.,"
					break
				case 0.375 * division:					//dotted semiquaver
					tempName += "h."
					break
				case division / 3:						//triplet quaver (1/3 of crochet)				//三連音
					break
				case division / 4:						//1/16 note (semiquaver)
					tempName += "h"
					break
				case 0.21875 * division:				//double-dotted demi-semiquaver
					tempName += "y.,"
					break
				case 0.1875 * division:					//dotted demi-semiquaver
					tempName += "y."
					break
				case division / 6:						//triplet semiquaver (1/3 of quaver)			//三連音
					break
				case division / 8:						//1/32 note (demi-semiquaver)
					tempName += "y"
					break
				case 0.09375 * division:				//dotted hemi-demi-semiquaver
					break
				case division / 12:						//triplet demi-semiquaver (1/3 of semiquaver)	//三連音
					break
				case division / 16:						//1/64 note (hemi-demi-semiquaver)
					break
			}
		} else if (myOctave == 3) {						//音高為C3~B3
			switch (noteDurationValue) {
				case 0.875 * division:					//double-dotted quaver
					tempName += "b.,"
					break
				case 0.75 * division:					//dotted quaver
					tempName += "b."
					break
				case 2 * division / 3:					//triplet crochet (1/3 of minim)				//三連音
					break
				case division / 2:						//1/8 note (quaver)
					tempName += "b"
					break
				case 0.4375 * division:					//double-dotted semiquaver
					tempName += "g.,"
					break
				case 0.375 * division:					//dotted semiquaver
					tempName += "g."
					break
				case division / 3:						//triplet quaver (1/3 of crochet)				//三連音
					break
				case division / 4:						//1/16 note (semiquaver)
					tempName += "g"
					break
				case 0.21875 * division:				//double-dotted demi-semiquaver
					tempName += "t.,"
					break
				case 0.1875 * division:					//dotted demi-semiquaver
					tempName += "t."
					break
				case division / 6:						//triplet semiquaver (1/3 of quaver)			//三連音
					break
				case division / 8:						//1/32 note (demi-semiquaver)
					tempName += "t"
					break
				case 0.09375 * division:				//dotted hemi-demi-semiquaver
					break
				case division / 12:						//triplet demi-semiquaver (1/3 of semiquaver)	//三連音
					break
				case division / 16:						//1/64 note (hemi-demi-semiquaver)
					break
			}

		} else {										//音高未低於C4
			switch (noteDurationValue) {
				case 0.875 * division:					//double-dotted quaver
					tempName += "v.,"
					break
				case 0.75 * division:					//dotted quaver
					tempName += "v."
					break
				case 2 * division / 3:					//triplet crochet (1/3 of minim)				//三連音
					break
				case division / 2:						//1/8 note (quaver)
					tempName += "v"
					break
				case 0.4375 * division:					//double-dotted semiquaver
					tempName += "f.,"
					break
				case 0.375 * division:					//dotted semiquaver
					tempName += "f."
					break
				case division / 3:						//triplet quaver (1/3 of crochet)				//三連音
					break
				case division / 4:						//1/16 note (semiquaver)
					tempName += "f"
					break
				case 0.21875 * division:				//double-dotted demi-semiquaver
					tempName += "r.,"
					break
				case 0.1875 * division:					//dotted demi-semiquaver
					tempName += "r."
					break
				case division / 6:						//triplet semiquaver (1/3 of quaver)			//三連音
					break
				case division / 8:						//1/32 note (demi-semiquaver)
					tempName += "r"
					break
				case 0.09375 * division:				//dotted hemi-demi-semiquaver
					break
				case division / 12:						//triplet demi-semiquaver (1/3 of semiquaver)	//三連音
					break
				case division / 16:						//1/64 note (hemi-demi-semiquaver)
					break
			}
		}

		return tempName

	}

}
